#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os, sys, site 
import re, urllib
import datetime, time
import shutil

import sqlite3dbm

from generator import * 

import web

from sqlobject import *
sqlhub.processConnection = connectionForURI('sqlite://'+ARTICLES_DB)

#render
from web.contrib.template import render_mako

render = render_mako(   directories=[PANEO_ROOT+'/_cms/templates/'],
                        input_encoding='utf-8',
                        output_encoding='utf-8',
                        default_filters=["none_to_blank", "unicode"],
                        encoding_errors='replace', 
                        imports = RENDER_IMPORTS )



class View:

    def __init__(self):
        self.cms = 'images'
        web.header("Content-Type", "text/html; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET( self ):
        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        dic.close()

        if scfg.get("PAGEMAKE"):
            if scfg.get("PAGEMAKE") == 'HTML':
                pages = GetHtmlMenuPages() 

        return render.images(  
                                cms = self.cms,                        
                                scfg = scfg, 
                                pages = pages,
                                mode = 'view',

                                id = None,
                                html_file = None,
        )


class Edit:

    def __init__(self):
        self.cms = 'images'
        web.header("Content-Type", "text/html; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET( self, id="index" ):

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        fields = dic.get('fields')
        dic.close()

        p = pages.get(id)
        if p is None:
            return web.notfound()

        if fields is None:
            fields = {}
        html_fields = p.GetPaneoImageFields('page',id,fields) 

        return render.images(     
                                    cms = self.cms,                        
                                    scfg = scfg, 
                                    pages = pages,
                                    mode = 'edit',

                                    id = id,
                                    html_fields = html_fields,
        )


    def POST( self, id="index" ):

        i = web.input()

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        fields = dic.get('fields')

        p = pages.get(id)
        if p is None:
            return web.notfound()

        dic['fields'] = p.PostPaneoImageFields('page',i,id,fields) 
        dic.close()
       
        return self.GET( id )

